package nemosofts.voxradio.activity;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.widget.SearchView;
import androidx.appcompat.widget.Toolbar;
import androidx.core.app.ActivityCompat;
import androidx.core.view.MenuItemCompat;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.ads.consent.ConsentInformation;
import com.google.ads.consent.ConsentStatus;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.ads.mediation.facebook.FacebookMediationAdapter;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.sothree.slidinguppanel.SlidingUpPanelLayout;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.util.ArrayList;

import nemosofts.voxradio.BuildConfig;
import nemosofts.voxradio.R;
import nemosofts.voxradio.adapter.AdapterEpisodeList;
import nemosofts.voxradio.asyncTask.LoadEpisode;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.dialog.VerifyDialog;
import nemosofts.voxradio.interfaces.EpisodeListener;
import nemosofts.voxradio.item.ItemCat;
import nemosofts.voxradio.item.ItemPodcasts;
import nemosofts.voxradio.item.ItemRadio;
import nemosofts.voxradio.utils.recycler.EndlessRecyclerViewScrollListener;
import nemosofts.voxradio.utils.GlobalBus;
import nemosofts.voxradio.utils.helper.Helper;
import nemosofts.voxradio.utils.SharedPref;
import okhttp3.RequestBody;

public class PodcastsByActivity extends NSoftsPlayerActivity {

    RecyclerView rv_radio;
    AdapterEpisodeList adapterRadioList;
    ArrayList<ItemRadio> arrayListRadio;
    Boolean isOver = false, isScroll = false, isLoading = false, isFromPush = false;
    int page_radio = 1;
    ProgressBar pb_radio;
    FloatingActionButton fab_radio;
    String error_msg;
    FrameLayout frameLayoutRadio;
    String addedFromRadio = "";
    String id = "", name = "";
    SearchView searchView;

    AdLoader adLoader;
    ArrayList<NativeAd> arrayListNativeAds = new ArrayList<>();

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        FrameLayout contentFrameLayout = findViewById(R.id.content_frame);
        getLayoutInflater().inflate(R.layout.activity_podcasts_by, contentFrameLayout);

        drawer.setDrawerLockMode(DrawerLayout.LOCK_MODE_LOCKED_CLOSED);
        ll_bottom_nav.setVisibility(View.GONE);
        ll_adView_player.setVisibility(View.VISIBLE);
        toolbar.setVisibility(View.GONE);

        id = getIntent().getStringExtra("id");
        name = getIntent().getStringExtra("name");
        addedFromRadio = "podcasts" + name;

        Toolbar toolbar1 = findViewById(R.id.toolbar_audio);
        toolbar1.setTitle(name);
        setSupportActionBar(toolbar1);
        if (getSupportActionBar() != null) {
            getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            getSupportActionBar().setDisplayShowHomeEnabled(true);
        }

        sharedPref = new SharedPref(this);
        helper = new Helper(this, (position, type) -> {
            Callback.isRadio = false;
            if (!Callback.addedFrom.equals(addedFromRadio)) {
                Callback.arrayList_play.clear();
                Callback.arrayList_play.addAll(arrayListRadio);
                Callback.addedFrom = addedFromRadio;
                Callback.isNewAdded = true;
            }
            Callback.playPos = position;

            Intent intent = new Intent(this, PlayerService.class);
            intent.setAction(PlayerService.ACTION_PLAY);
            startService(intent);
        });
        helper.showBannerAd(ll_adView_player);

        arrayListRadio = new ArrayList<>();

        frameLayoutRadio = findViewById(R.id.fl_empty);
        fab_radio = findViewById(R.id.fab);
        pb_radio = findViewById(R.id.pb);
        rv_radio = findViewById(R.id.rv);
        rv_radio.setHasFixedSize(true);

        LinearLayoutManager llm_banner = new LinearLayoutManager(this);
        rv_radio.setLayoutManager(llm_banner);
        rv_radio.setItemAnimator(new DefaultItemAnimator());
        rv_radio.setHasFixedSize(true);
        rv_radio.setNestedScrollingEnabled(false);

        rv_radio.addOnScrollListener(new EndlessRecyclerViewScrollListener(llm_banner) {
            @Override
            public void onLoadMore(int p, int totalItemsCount) {
                if (Boolean.TRUE.equals(!isOver && !isLoading)) {
                    isLoading = true;
                    new Handler().postDelayed(() -> {
                        isScroll = true;
                        getData();
                    }, 0);
                }
            }
        });

        rv_radio.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                int firstVisibleItem = llm_banner.findFirstVisibleItemPosition();
                if (firstVisibleItem > 6) {
                    fab_radio.show();
                } else {
                    fab_radio.hide();
                }
            }
        });

        fab_radio.setOnClickListener(v -> rv_radio.smoothScrollToPosition(0));

        getData();

        findViewById(R.id.fab_d).setOnClickListener(v -> {
            Intent intent2 = new Intent(PodcastsByActivity.this, WebActivity.class);
            intent2.putExtra("web_url", BuildConfig.BASE_URL+"radio_description.php?pod_id="+id);
            intent2.putExtra("page_title", name);
            ActivityCompat.startActivity(PodcastsByActivity.this, intent2, null);
        });

    }

    @Override
    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        if (item.getItemId() == android.R.id.home) {
            onBackPressed();
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.menu_search, menu);
        MenuItem item = menu.findItem(R.id.menu_search);
        MenuItemCompat.setShowAsAction(item, MenuItemCompat.SHOW_AS_ACTION_COLLAPSE_ACTION_VIEW | MenuItemCompat.SHOW_AS_ACTION_IF_ROOM);
        searchView = (SearchView) menu.findItem(R.id.menu_search).getActionView();
        searchView.setOnQueryTextListener(queryTextListener);
        return super.onCreateOptionsMenu(menu);
    }

    SearchView.OnQueryTextListener queryTextListener = new SearchView.OnQueryTextListener() {

        @Override
        public boolean onQueryTextSubmit(String s) {
            return false;
        }

        @SuppressLint("NotifyDataSetChanged")
        @Override
        public boolean onQueryTextChange(String s) {
            if (adapterRadioList != null && (!searchView.isIconified())) {
                adapterRadioList.getFilter().filter(s);
                adapterRadioList.notifyDataSetChanged();
            }
            return true;
        }
    };

    private void getData() {
        if (helper.isNetworkAvailable()) {
            addedFromRadio = "podcasts" + name;
            RequestBody requestBody = helper.getAPIRequest(Callback.METHOD_PODCASTS_BY, page_radio, id,"", "", "", new SharedPref(PodcastsByActivity.this).getUserId(), "", "", "", "", "", "", "",  null);
            LoadEpisode loadRadio = new LoadEpisode(new EpisodeListener() {
                @Override
                public void onStart() {
                    if (arrayListRadio.isEmpty()) {
                        frameLayoutRadio.setVisibility(View.GONE);
                        rv_radio.setVisibility(View.GONE);
                        pb_radio.setVisibility(View.VISIBLE);
                    }
                }

                @Override
                public void onEnd(String success, String verifyStatus, String message, ArrayList<ItemRadio> arrayListRa) {
                    if (success.equals("1")) {
                        if (!verifyStatus.equals("-1")) {
                            if (arrayListRa.isEmpty()) {
                                isOver = true;
                                error_msg = getString(R.string.err_no_data_found);
                                setEmpty();
                            } else {
                                arrayListRadio.addAll(arrayListRa);
                                if (Boolean.TRUE.equals(isScroll) && Callback.addedFrom.equals(addedFromRadio)) {
                                    Callback.arrayList_play.clear();
                                    Callback.arrayList_play.addAll(arrayListRadio);
                                    try {
                                        GlobalBus.getBus().postSticky(new ItemPodcasts("", "", null));
                                    } catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                                page_radio = page_radio + 1;
                                setAdapter();
                            }
                        } else {
                            new VerifyDialog(PodcastsByActivity.this, getString(R.string.err_unauthorized_access), message);
                        }
                    } else {
                        error_msg = getString(R.string.err_server_not_connected);
                        setEmpty();
                    }
                    isLoading = false;
                }
            }, requestBody);
            loadRadio.execute();
        } else {
            error_msg = getString(R.string.err_internet_not_connected);
            setEmpty();
        }
    }

    @SuppressLint("NotifyDataSetChanged")
    public void setAdapter() {
        if(Boolean.FALSE.equals(isScroll)) {
            adapterRadioList = new AdapterEpisodeList(this, arrayListRadio, position -> helper.showInterAd(position, ""));
            rv_radio.setAdapter(adapterRadioList);
            rv_radio.scheduleLayoutAnimation();
            setEmpty();
            loadNativeAds();
        } else {
            adapterRadioList.notifyDataSetChanged();
        }
    }

    private void loadNativeAds() {
        if (Boolean.TRUE.equals(Callback.isNativeAd
                && !Callback.adNetwork.equals(Callback.AD_TYPE_STARTAPP) && !Callback.adNetwork.equals(Callback.AD_TYPE_IRONSOURCE) && arrayListRadio.size() >= 10)) {
            AdLoader.Builder builder = new AdLoader.Builder(PodcastsByActivity.this, Callback.nativeAdID);

            Bundle extras = new Bundle();
            if (ConsentInformation.getInstance(PodcastsByActivity.this).getConsentStatus() != ConsentStatus.PERSONALIZED) {
                extras.putString("npa", "1");
            }

            AdRequest adRequest;
            if(Callback.adNetwork.equals(Callback.AD_TYPE_ADMOB)) {
                adRequest = new AdRequest.Builder()
                        .addNetworkExtrasBundle(AdMobAdapter.class, extras)
                        .build();
            } else {
                adRequest = new AdRequest.Builder()
                        .addNetworkExtrasBundle(AdMobAdapter.class, new Bundle())
                        .addNetworkExtrasBundle(FacebookMediationAdapter.class, extras)
                        .build();
            }

            adLoader = builder.forNativeAd(nativeAd -> {
                try {
                    if(adLoader.isLoading()) {
                        arrayListNativeAds.add(nativeAd);
                    } else {
                        arrayListNativeAds.add(nativeAd);
                        adapterRadioList.addAds(arrayListNativeAds);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }).build();
            adLoader.loadAds(adRequest, 5);
        }
    }

    private void setEmpty() {
        if (!arrayListRadio.isEmpty()) {
            rv_radio.setVisibility(View.VISIBLE);
            pb_radio.setVisibility(View.INVISIBLE);
            frameLayoutRadio.setVisibility(View.GONE);
        } else {
            pb_radio.setVisibility(View.INVISIBLE);
            rv_radio.setVisibility(View.GONE);
            frameLayoutRadio.setVisibility(View.VISIBLE);

            frameLayoutRadio.removeAllViews();
            LayoutInflater inflater = (LayoutInflater) getSystemService(Context.LAYOUT_INFLATER_SERVICE);

            @SuppressLint("InflateParams") View myView = inflater.inflate(R.layout.row_empty, null);

            TextView textView = myView.findViewById(R.id.tv_empty_msg);
            textView.setText(error_msg);

            myView.findViewById(R.id.ll_empty_try).setOnClickListener(v -> getData());

            frameLayoutRadio.addView(myView);
        }
    }

    @Override
    public void onBackPressed() {
        if (mLayout.getPanelState().equals(SlidingUpPanelLayout.PanelState.EXPANDED)) {
            mLayout.setPanelState(SlidingUpPanelLayout.PanelState.COLLAPSED);
        } else if (Boolean.TRUE.equals(isFromPush)) {
            Intent intent = new Intent(PodcastsByActivity.this, MainActivity.class);
            startActivity(intent);
            finish();
        } else {
            super.onBackPressed();
        }
    }

    @SuppressLint("NotifyDataSetChanged")
    @Subscribe(sticky = true, threadMode = ThreadMode.MAIN)
    public void onEquilizerChange(ItemCat itemCat) {
        if (adapterRadioList != null){
            adapterRadioList.notifyDataSetChanged();
        }
        GlobalBus.getBus().removeStickyEvent(itemCat);
    }
}